/*
 * $Id: pgpSig.h,v 1.6 2001/01/25 22:11:35 jeffc Exp $
 */

#ifndef Included_pgpSig_h
#define Included_pgpSigh

#include "pgpUsuals.h"

PGP_BEGIN_C_DECLARATIONS

#include "pgpOpaqueStructs.h"

/* These are the public access functions to the SigData object */

PGPByte pgpSigDataType (PGPSigData const *sig);
PGPByte pgpSigDataVersion (PGPSigData const *sig);
PGPByte pgpSigDataPKAlg (PGPSigData const *sig);
PGPHashVTBL const  *pgpSigDataHash (PGPSigData const *sig);
PGPByte const  *pgpSigDataExtra (PGPSigData const *sig, unsigned *len);
PGPUInt32  pgpSigDataTimestamp (PGPSigData const *sig);

/* caller must free the key ID */
PGPError		pgpGetSigDataKeyID( PGPSigData const *sig,
				PGPKeyID *outRef);

/*
 * Check a signature against a given public key and hash.
 * Returns 0 if it did not check, and 1 if it did.
 * Returns <0 on some sort of error.
 * *Do* make sure it's the right hash you're passing in.
 */
int  pgpSigDataCheck (PGPSigData const *sig,
	PGPKeyDBObjRef pub, PGPByte const *hash);

/*
 * Below this line are the internal functions that are used only
 * inside the PGP Library.  Applciations probably shouldn't be
 * using these functions.
 */

/*
 * Internal variant of pgpSigDataCheck, not for public use.  Signature *must*
 * be known good.
 */
int
pgpSigDataCheckBuf (PGPByte const *sig, PGPSize len, PGPKeyDBObjRef pub,
		void const *hash);

/* Check the buffer for a valid signature block and obtain the sigtype */
int  pgpSigDataSigType (PGPByte const *buf, PGPSize len);

int  pgpSigDataNestFlag(PGPByte const *buf, PGPSize len);

unsigned  pgpSigDataDistinctHashCount (PGPSigData const *siglist);
unsigned  pgpSigDataDistinctHashes (PGPSigData const *siglist,
	PGPByte *buf);

int  pgpSigDataAdd ( PGPContextRef cdkContext,
	PGPSigData **siglist, int type, PGPByte const *buf,
	PGPSize len);
PGPSigData  *pgpSigDataNext (PGPSigData const *sig);
void  pgpSigDataFreeList (PGPSigData *siglist);

PGP_END_C_DECLARATIONS

#endif /* Included_pgpSig_h */
